--
-- This file contains the SQL and PL/SQL code that will take an XML file
-- generated from a SQL Server database, parse the data and insert the 
-- records into the DEMO.PRODUCTS table
--


CREATE DIRECTORY XML_DIR as 'C:\XML_CODE\EXAMPLE'
;

declare
  xmlSource BFILE := BFILENAME('XML_DIR', 'products.xml');
  xmlString CLOB; 

  amount integer;
  rowsp integer; 

begin

  DBMS_LOB.CREATETEMPORARY(xmlString,TRUE, DBMS_LOB.SESSION);

  DBMS_LOB.OPEN(xmlSource, DBMS_LOB.LOB_READONLY);
  amount := dbms_lob.getlength(xmlSource);

  DBMS_LOB.OPEN(xmlString, DBMS_LOB.LOB_READWRITE);
  DBMS_LOB.LOADFROMFILE(xmlString, xmlSource, amount);

  xmlgen.resetOptions; 
  xmlgen.setRowTag('Products'); 
  xmlgen.setIgnoreTagCase(xmlgen.IGNORE_CASE); 

  rowsp := xmlgen.insertXML('demo.products',xmlString); 

  dbms_output.put_line('Rows processed = '|| TO_CHAR(rowsp)); 

  dbms_lob.close(xmlSource); 
  dbms_lob.close(xmlString); 

  dbms_lob.freetemporary(xmlString); 

  COMMIT;

END;
/

